/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.IDocument;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dm.FONIDataModel;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.dt.SingleNode;

import java.sql.*;

/**
 *  Implementation of function sql:rawExecute(PreparedStatement, parameters...).
 */
public class SqlRawExec extends Function {
    
    static QName qname = QName.get(SqlConnection.NS, "rawExec");
    static Prototype[] protos = { 
        new Prototype(qname, Type.NODE.star, RT1.class)
	   .arg("connection", SqlConnection.TYPE_CONNECTION)
	   .arg("statement", Type.STRING),
        new Prototype(qname, SqlConnection.TYPE_RESULTSET, RT2.class, true)
	   .arg("statement", SqlConnection.TYPE_PSTATEMENT) 
	// .arg("parameters...", Type.ITEM)
    };
    public Prototype[] getProtos() { return protos; }

    public static class RT1 extends Function.Call {

        public Value eval( Focus focus, EvalContext context )
	    throws XQueryException {
	    context.at(this);
	    try {
		Connection con = (Connection) objArg( args, 0, Connection.class,
						      focus, context);
		Statement stat = con.createStatement() ;
		String src = args[1].evalAsString(focus, context);
		ResultSet rs = stat.executeQuery(src);
		return new SqlConnection.RawResult(rs);
	    }
	    catch (SQLException e) {
		context.error(this, new EvalException(e.getMessage(), e));
		return null; // dummy
	    }
        }
    }

    public static class RT2 extends Function.Call {

        public Value eval( Focus focus, EvalContext context )
	    throws XQueryException {
	    context.at(this);
	    PreparedStatement statement =
		(PreparedStatement) objArg(args, 0, PreparedStatement.class,
					   focus, context);
	    try {
		SqlConnection.Stat stat = new SqlConnection.Stat(statement);
		for(int p = 1; p < args.length; p++) {
		    Item param = args[p].evalAsOptItem(focus, context );
		    stat.setArg(p, param);
		}
		ResultSet rs = statement.executeQuery();
		return new SqlConnection.RawResult(rs);
	    }
	    catch (SQLException e) {
		context.error(this, new EvalException(e.getMessage(), e));
		return null; // dummy
	    }
        }
    }
}
