/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;

import net.xfra.qizxopen.dm.FulltextQuery;
import net.xfra.qizxopen.util.*;

/**
 *	Convenience form of fulltext query.
 */
public class XfnAnyWord extends Function
{
   static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "any-word");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	 .arg("words", Type.STRING.plus).arg("context", Type.NODE.star),
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	 .arg("words", Type.STRING.plus)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends XfnFulltext.Exec {

	public FulltextQuery preparedQuery( Focus focus, EvalContext context,
					    WordSifter sifter )
	    throws XQueryException {

	    Value words = args[0].eval(focus, context);
	    context.at(this);
	    StringBuffer qb = new StringBuffer();
	    for(boolean first = true; words.next(); ) {
		if(!first) qb.append(" OR ");
		first = false;
		qb.append(words.asString());
	    }
	    if(args.length > 1)
		container = args[1];
	    return prepareQuery( qb.toString(), context, sifter );
	}
    }
}

