/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.LimitReachedException;
import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dm.EventDrivenBuilder;
import net.xfra.qizxopen.xquery.dt.ArraySequence;

import java.io.StringWriter;
import java.io.PrintWriter;

/**
 *  Parses and evaluates a XQuery expression.
 *  The expression is parsed in the global context of the current query
 *  or module, without access to local variables.
 */
public class XfnEval extends Function
{
    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "eval");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.NODE.star, Exec.class)
	 .arg("expression", Type.STRING)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);
	    String querySrc = args[0].evalAsString(focus, context);
	    querySrc = querySrc.replace('\r', ' ');
	    XQueryProcessor proc =
		(XQueryProcessor) context.getProperty(":processor");
	    try {
		return proc.eval(querySrc, focus, context);
	    }
	    catch (XQueryException e) {
		context.error(this, new EvalException(e.getMessage(), e));
		return null; // dummy
	    }
	}
    }
} 
