/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.dm.Node;

import net.xfra.qizxopen.dm.FulltextQuery;
import net.xfra.qizxopen.util.*;

/**
 *  Implementation of function x:fulltext:
 *    low-efficiency fallback implementation used in absence of fulltext indexing.
 */
public class XfnFulltext extends Function {

    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "fulltext");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	.arg("query", Type.STRING).arg("context", Type.NODE.star),
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	    .arg("query", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    // get word sifter from context: may have been set as a system property
    static WordSifter getWordSifter(EvalContext context) {
	WordSifter extr = (WordSifter) context.getProperty("word-sifter");
	return extr != null? extr : new DefaultWordSifter();
    }

    public static class Exec extends Function.BoolCall {

	public Expression container;
	FulltextQuery previousCompiled;
	String previousQuery;
	EvalContext previousContext;

	// cached compilation:
	synchronized 
	protected FulltextQuery prepareQuery( String query, EvalContext context,
					      WordSifter sifter )
	    throws XQueryException {
	    if(context == previousContext && query.equals(previousQuery))
		return previousCompiled;
	    try {
		if(sifter == null)
		    sifter = getWordSifter(context);
		previousCompiled = FulltextQuery.parseQuery(query, sifter);
		previousQuery = query;
		previousContext = context;
		return previousCompiled;
	    }
	    catch (FulltextQuery.ParseException e) {
		context.error(args[0], "full-text query error: "+e.getMessage());
	    }
	    return null;
	}

	public FulltextQuery preparedQuery( Focus focus, EvalContext context,
					    WordSifter sifter )
	    throws XQueryException {
	    if(args.length > 1)
		container = args[1];
	    return prepareQuery( args[0].evalAsString(focus, context), context, sifter );
	}

        public boolean evalAsBoolean(Focus focus, EvalContext context)
	    throws XQueryException {
	    FulltextQuery query = preparedQuery(focus, context, null);
	    if(args.length > 1) {
		Value seq = args[1].eval(focus, context);
		// stop on first matching node:
		for(; seq.next(); ) {
		    Node node = seq.asNode();
		    if(query.matches(node))
			return true;
		}
		return false;
	    }
	    else {
		checkFocus(focus, context);
		return query.matches( focus.getItem().asNode() );
	    }
	}
    }
}
