/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.dm.Node;

import net.xfra.qizxopen.util.*;

/**
 *  Implementation of function x:like.
 */
public class XfnLike extends Function {

    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "like");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	.arg("pattern", Type.STRING).arg("context", Type.NODE.star),
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	    .arg("pattern", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.BoolCall {

	public Expression container;
	StringPattern previousPattern;
	String previous;
	EvalContext previousContext;

	protected StringPattern preparePattern( String pattern,
						EvalContext context ) {
	    if(context == previousContext && pattern.equals(previous))
		return previousPattern;
	    previousPattern = new LikePattern(pattern);
	    previous = pattern;
	    previousContext = context;
	    return previousPattern;
	}

	public StringPattern preparedPattern( EvalContext context )
	    throws XQueryException {
	    if(args.length > 1)
		container = args[1];
	    return preparePattern(args[0].evalAsString(null, context), context);
	}

        public boolean evalAsBoolean(Focus focus, EvalContext context)
	    throws XQueryException {
	    StringPattern pattern = preparedPattern( context);
	    if(args.length > 1) {
		Value seq = args[1].eval(focus, context);
		// stop on first matching node:
		for(; seq.next(); ) {
		    Node node = seq.asNode();
		    if(pattern.matches(node.getStringValue().toCharArray()))
			return true;
		}
		return false;
	    }
	    else {
		checkFocus(focus, context);
		return pattern.matches( focus.getItem().asNode().
					getStringValue().toCharArray() );
	    }
	}
    }
}
