/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.fn.JavaFunction;

/**
 *	Function system-property: returns a system- or application-defined property.
 */
public class XfnSystemProperty extends Function {
    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "system-property");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.ITEM.opt, Exec.class)
	    .arg("name", Type.STRING)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {
       public Value eval(Focus focus, EvalContext context) throws XQueryException {
	   String name = args[0].evalAsString(focus, context);
	   return JavaFunction.convertObject( context.getProperty(name) );
       }
    }
}
