/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.IDocument;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dm.FONIDataModel;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.dt.SingleNode;

import java.io.FileOutputStream;
import java.util.Properties;
import javax.xml.transform.TransformerException;

/**
 *  Implementation of function x:transform().
 *
 * 	x:transform( $node, $templates as string, $parameters as element()?,
 * 	             [ $options as element() ] )
 * 	    as node()?
 *  @see XQueryProcessor.xsltTransform       
 */
public class XfnTransform extends Function {

    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "transform");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.NODE.opt, Exec.class)
	    .arg("node", Type.NODE).arg("templates", Type.STRING)
        .arg("parameters", Type.ELEMENT),
        new Prototype(qfname, Type.NODE.opt, Exec.class)
	    .arg("node", Type.NODE).arg("templates", Type.STRING)
	    .arg("parameters", Type.ELEMENT).arg("options", Type.ELEMENT)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval( Focus focus, EvalContext context )
	    throws XQueryException {
	    Node source = args[0].evalAsOptNode(focus, context);
	    String templates = args[1].evalAsString(focus, context);
	    Node paramNode = args[2].evalAsOptNode(focus, context);
	    Node optionNode = (args.length < 4)?
		               null : args[3].evalAsNode(focus, context);
            context.at(this);
	    try {
		// helper method in XQueryProcessor: 
		XQueryProcessor xqpro =
		    (XQueryProcessor) context.getProperty(":processor");
		// options (String value always)
		Properties options = new Properties();
		if(optionNode != null) {
		    Value opts = optionNode.getAttributes();
		    for( ; opts.next(); ) {
			Node option = opts.asNode();
			options.put( option.getNodeName().toString(),
				     option.getStringValue() );
		    }
		}
		// parameters (String value always)
		Value params = paramNode.getAttributes();
		Properties parameters = new Properties();
		for( ; params.next(); ) {
		    Node param = params.asNode();
		    parameters.put( param.getNodeName().toString(),
				    param.getStringValue() );
		}
		
		IDocument doc = xqpro.xslTransform(source, templates,
						   parameters, options);
		if(doc == null)
		    return Value.empty;
		return new SingleNode(new FONIDataModel(doc).getDocumentNode());
	    }
	    catch (EvalException e) {
		throw e;	// just to avoid the next catch
	    }
	    catch (Exception e) {
		//e.printStackTrace();
		context.error(this, new EvalException("XSLT error: "+
						      e.toString(), e));
	    }
	    return null;	// dummy
        }
    }
}
