/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.io.ObjectInputStream;
import java.io.IOException;

/**
 *	Default DateSifter implementation: uses a DateFormat (by default the
 *	short format of the default locale.)
 */
public class DefaultDateSifter implements DateSifter, java.io.Serializable
{
    DateFormat format;
    transient ParsePosition position = new ParsePosition(0);
    transient BitIdSet badFirstChars = null;	// accelerator

    /**
     * Uses the default locale.
     */
    public DefaultDateSifter() {
        this.format = DateFormat.getDateInstance(DateFormat.SHORT);
	
    }

    /**
     *	General case: use a DateFormat.
     */
    public DefaultDateSifter(DateFormat format) {
	this.format = format;
    }

    /*
     *	Returns a number of milliseconds since 1970-01-01 00:00:00 UTC.
     *	@param value a possible date to convert.
     */
    public double convert( String value ) {
	// boost: reject if first char is in a set
	if(badFirstChars != null && badFirstChars.test(value.charAt(0)))
	    return Double.NaN;
	position.setIndex(0);
	Date d = format.parse(value, position);
	if(d == null || position.getIndex() == 0) {
	    if(position.getErrorIndex() == 0) {	// rejected at 
		if(badFirstChars == null)
		    badFirstChars = new BitIdSet();
		badFirstChars.add(value.charAt(0));
	    }
	    return Double.NaN;
	}
	return d.getTime();
    }

    private void readObject(ObjectInputStream stream)
	throws IOException, ClassNotFoundException {
	stream.defaultReadObject();
	position = new ParsePosition(0);
    }

/*
    static public void main( String args[] )
    {
        try {
	    DefaultDateSifter sifter =
		new DefaultDateSifter(new SimpleDateFormat("yyyy-MM-dd"));
            for(int a = 0; a < args.length; a++) {
		double S = 0;
                String arg = args[a];
		for(int r = 0; r < 2000000; r++) {
		    double d = sifter.convert(arg);
		    if(d == d)
			S += d;
		}
		System.err.println("S="+S);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
 */
} // end of class DefaultDateSifter
