/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.text.*;
import java.util.Locale;
import java.io.ObjectInputStream;
import java.io.IOException;

/**
 *	Converts a number using a locale or a Java NumberFormat.
 */
public class DefaultNumberSifter implements NumberSifter, java.io.Serializable
{
    NumberFormat format;
    transient ParsePosition position = new ParsePosition(0);

    /**
     * Uses the default locale.
     */
    public DefaultNumberSifter() {
	format = new DecimalFormat("############.##", new DecimalFormatSymbols(Locale.US));
	format.setMinimumFractionDigits(0);
	format.setParseIntegerOnly(false);	// what's that crap?
    }

    /**
     *	General case: use a NumberFormat.
     */
    public DefaultNumberSifter(NumberFormat format) {
	this.format = format;
    }

    public double convert( String value ) {
	position.setIndex(0);
	Number n = format.parse(value, position);
	
	int pos = position.getIndex();
	if( n == null)
	    return Double.NaN;
	if(pos < value.length() ) {
	    if(!Character.isWhitespace(value.charAt(pos)))
		return Double.NaN;
	}
	return n.doubleValue();
    }

    private void readObject(ObjectInputStream stream)
	throws IOException, ClassNotFoundException {
	stream.defaultReadObject();
	position = new ParsePosition(0);
    }

    static public void main( String args[] )
    {
        try {
	    DefaultNumberSifter sifter = new DefaultNumberSifter();
            for(int a = 0; a < args.length; a++) {
		double S = 0;
                String arg = args[a];
		for(int r = 0; r < 1000000; r++) {
		    double d = sifter.convert(arg);
		    if(d == d)
			S += d;
		}
		System.err.println("S="+S);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
} // end of class DefaultNumberSifter
