/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.util;

/**
 * An IdSet that is the difference between a main set and a list of excluded sets.
 */
public class DifferenceIdSet extends IdSet
{
    IdSet main;
    IdSet[] excluded;

    public DifferenceIdSet(IdSet main, IdSet[] excluded) {
        this.main = main;
	this.excluded = excluded;
    }

    public boolean test( int id ) {
	if(!main.test(id))
	    return false;
	for(int e = excluded.length; --e >= 0; )
	    if(excluded[e].test(id))
		return false;
	return true;
    }

    public int getNext( int id ) {
	for(;;) {
	    int next = main.getNext(id);
	    if(next < 0)
		return next;
	    int e = excluded.length;
	    for( ; --e >= 0; ) {
		int ex = excluded[e].getNext(next);
		if(ex == next)
		    break;
	    }
	    if(e < 0)
		return next;
	    id = next + 1;
	}
    }

    public IdSet copy() {
	IdSet[] list = new IdSet[excluded.length] ;
	for(int e = excluded.length; --e >= 0; )
	    list[e] = excluded[e].copy();
	return new DifferenceIdSet(main.copy(), list);
    }   
}
