/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *	A simple hash table meant for efficiency. 
 *	The key (subclass of Key) also bears the value.
 */
public class HTable
{
    public HTable( int capacity ) {
	hash = new Key[capacity];
	maxCount = (int) (LOAD_FACTOR * hash.length);
    }

    public HTable( ) {
	this(3);
    }

    public abstract static class Key {
	public Key next;
	public abstract Key duplicate();
    }

    final static double LOAD_FACTOR = 1.0;
    protected Key[] hash;
    protected int count = 0;
    protected int maxCount;

    public int getSize() {
	return count;
    }

    public Key get( Key probe ) {
	int h = (probe.hashCode() & 0x7FFFFFFF) % hash.length;
	for( Key c = hash[h]; c != null; c = c.next)
	    if(c.equals(probe))
		return c;
	return null;
    }

    public Key put( Key probe ) {
	int h = (probe.hashCode() & 0x7FFFFFFF) % hash.length;
	for( Key c = hash[h]; c != null; c = c.next)
	    if(c.equals(probe))
		return c;
	if(++ count > maxCount) {
	    resize();
	    h = (probe.hashCode() & 0x7FFFFFFF) % hash.length;	// may have changed
	}
	Key nc = probe.duplicate();
	nc.next = hash[h];
	hash[h] = nc;
	return nc;
    }

    /**
     *	No check: allows duplicate keys.
     */
    public Key add( Key probe ) {
	int h = (probe.hashCode() & 0x7FFFFFFF) % hash.length;
	Key nc = probe.duplicate();
	nc.next = hash[h];
	hash[h] = nc;
	++ count;
	return nc;
    }

    public void directPut( Key entry ) {
	if(++ count > maxCount)
	    resize();
	int h = (entry.hashCode() & 0x7FFFFFFF) % hash.length;
	entry.next = hash[h];
	hash[h] = entry;
    }

    public Key[] getKeys(Key[] keys) {
	int s = 0;
	for(int h = hash.length; --h >= 0; )
	    for( Key c = hash[h]; c != null; c = c.next)
		keys[s++] = c;
	return keys;
    }

    public void clear() {
	for(int h = hash.length; --h >= 0; )
	    hash[h] = null;
	count = 0;
    }

    void resize() {
	Key[] old = hash;

	int emptyC = 0;	for(int i = 0; i < hash.length; i++) if(hash[i] == null) emptyC ++;
	
	if(old.length - emptyC < count / 4) {
	    for(int i = 0, cnt = 3; i < hash.length; i++) if(hash[i] != null) { 
		System.err.print(i+" : ");
		int kcnt = 0;
		for(Key c = hash[i]; c != null && kcnt++ < 100 ; c = c.next) System.err.print(" "+c);
		if(kcnt > 100) System.err.print(" ... and more ");
		System.err.println();
		if(--cnt <= 0) break;
	    }
	}

	hash = new Key[ old.length * 2 + 1 ];
	for(int ic = old.length; --ic >= 0; ) {
	    for(Key c = old[ic]; c != null; ) {
		Key ac = c;
		c = c.next;
		int h = (ac.hashCode() & 0x7FFFFFFF) % hash.length;
		ac.next = hash[h];
		hash[h] = ac;
	    }
	}
	maxCount = (int) (LOAD_FACTOR * hash.length);
    }
} // end of class HTable
