/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.util.*;

/**
 * Management of a local table of qualified names (for documents or collections).
 * <p>Names are accessed by index or by value (namespace+localname).
 */
public class NSTable
{
    /**
     * Searches a name and returns its index in the table. If the name is not found, it
     * is inserted.
     * 
     * @param uri Namespace URI.
     * @param localName
     */
    public int  enter( String uri, String localName )
    {
	probe.uri = uri;
	probe.localName = localName;
	Key key = (Key) nameMap_.get(probe);
	if( key != null )
	    return key.code;
	return addName(uri, localName);
    }

    public int  enter( QName name ) {
	return enter(name.getURI(), name.getLocalName());
    }
    /**
     * Lookup of a qualified name.
     * 
     * @return the index of the name in the table, or -1 if not found.
     */
    public int  find( String uri, String localName )
    {
	probe.uri = uri;
	probe.localName = localName;
	Key key = (Key) nameMap_.get(probe);
	return key != null ? key.code : -1;
    }
    /**
     * Lookup of a qualified name.
     * 
     * @return the index of the name in the table, or -1 if not found.
     */
    public int  find( QName name ) {
	return find(name.getURI(), name.getLocalName());
    }

    /**
     * Inserts a name without check (for loading).
     */
    public int addName( String uri, String localName ) {
	Key key = new Key(uri, localName);
	key.code = names_.size();
	names_.addElement(QName.get(uri, localName));
	nameMap_.put(key, key);
	
	return key.code;
    }

    /**
     * Gets the unique name associated with an index.
     */
    public QName  getName(int rank) {
	if (rank < 0 || rank >= names_.size())
	    throw new IllegalArgumentException("bad rank "+rank);
	return (QName) names_.elementAt(rank);
    }

    /**
     * Returns the number of names stored in this table.
     */
    public int  size() {
	return names_.size();
    }
    /**
     * Clears all the contents.
     */
    public void  clear() {
	names_.clear();
	nameMap_ = new HashMap();
    }

    public Namespace[] getNamespaces() {
	Vector nst = new Vector();
	for(int n = names_.size(), ns; --n >= 0; ) {
	    Namespace ens = getName(n).getNamespace();
	    for( ns = nst.size(); --ns >= 0; )
		if(ens == nst.elementAt(ns))
		    break;
	    if(ns < 0)
		nst.addElement(ens);
	}
	return (Namespace[]) nst.toArray(new Namespace[ nst.size()]);
    }

    static class Key {
	Key( String uri, String localName ) {
	    this.uri = uri;
	    this.localName = localName;
	}

	public int hashCode() {
	    return uri.hashCode() ^ localName.hashCode();
	}
	public boolean equals(Object other) {
	    if (other == null || !(other instanceof Key))
		return false;
	    Key n = (Key) other;
	    
	    return uri.equals(n.uri) && localName.equals(n.localName);
	}

	String uri;
	String localName;
	int    code;
    }

    // instance variables:
    Vector  names_ = new Vector(32, 16);
    HashMap nameMap_ = new HashMap();
    Key     probe = new Key(null, null);
}
