/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
/*
 * Copyright (c) 2001-2002 Pixware. 
 *
 * Author: Hussein Shafie
 *
 */
package net.xfra.qizxopen.util;

import java.util.Hashtable;

/**
 *	Unique representation of a namespace.
 */
public final class Namespace
{
    private static Hashtable namespaces = new Hashtable();

    /** the blank namespace */
    public static final Namespace NONE  = get("");
    /** the XML namespace: http://www.w3.org/XML/1998/namespace */
    public static final Namespace XML =
	get("http://www.w3.org/XML/1998/namespace");
    /** The XLINK namespace: http://www.w3.org/1999/xlink */
    public static final Namespace XLINK =
	get("http://www.w3.org/1999/xlink");
    /** The XSLT namespace: http://www.w3.org/1999/XSL/Transform */
    public static final Namespace XSLT  =
	get("http://www.w3.org/1999/XSL/Transform");
    /** The XSL namespace: "http://www.w3.org/1999/XSL/Format */
    public static final Namespace XSL   =
	get("http://www.w3.org/1999/XSL/Format");
    /** The XML Schema Definition namespace: http://www.w3.org/2001/XMLSchema */
    public static final Namespace XSD =
	get("http://www.w3.org/2001/XMLSchema");
    /** The XSI namespace: http://www.w3.org/2001/XMLSchema-instance */
    public static final Namespace XSI =
	get("http://www.w3.org/2001/XMLSchema-instance");
    /** The XQuery functions namespace */
    public static final Namespace FN =
	get("http://www.w3.org/2003/05/xquery-functions");
    /** The XQuery operators namespace */
    public static final Namespace OP =
	get("http://www.w3.org/2003/05/xquery-operators");
    /** The XPath extended datatypes namespace */
    public static final Namespace XDT =
	get("http://www.w3.org/2003/11/xpath-datatypes");

    private String uri;
    /**
     *	Gets a Namespace object from an URI.
     */
    public static Namespace get(String uri) {
	if (uri == null)
	    throw new IllegalArgumentException("null uri");

	Namespace ns = (Namespace) namespaces.get(uri);
	if (ns == null) {
	    ns = new Namespace(uri);
	    namespaces.put(uri, ns);
	}

	return ns;
    }

    private Namespace(String uri) {
	this.uri = uri;
    }

    public String getURI() {
	return uri;
    }

    public boolean equals(Object other) {
	return (other == this);
    }

    public int hashCode() {
	return System.identityHashCode(this);
    }

    public String toString() {
	return uri;
    }

    public int compareTo(Namespace other) {
	return uri.compareTo(other.uri);
    }
}

