/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;
import java.util.Vector;

public class QuickSort
{
    public interface Compare {
	int compare(Object o1, Object o2);
    }

    public static void sort(Object[] values, Compare compare) {
	sort(values, 0, values.length-1, compare);
    }

    /****
     *	Array version: Sort from first to last <i>included</i>.
     */
    public static void sort(Object[] values, int first, int last, Compare compare)
    {
	int f = first, l = last;
	Object pivot;

	if (last > first)
	{
	    pivot = values[(first + last) / 2];
	    while (f <= l)
	    {
		while (f < last && compare.compare(values[f], pivot) < 0)
		    ++f;
		while (l > first && compare.compare(values[l], pivot) > 0)
		    --l;
		if (f <= l) {
		    Object temp = values[f]; 
		    values[f] = values[l];
		    values[l] = temp;
		    ++f;
		    --l;
		}
	    }

	    if (first < l)
		sort(values, first, l, compare);
	    if (f < last)
		sort(values, f, last, compare);
	}
    }

    public static void sort(Vector values, Compare compare) {
	sort(values, 0, values.size() - 1, compare);
    }

    /****
     *	Vector version: Sort from first to last <i>included</i>.
     */
    public static void sort(Vector values, int first, int last, Compare compare)
    {
	int f = first, l = last;
	Object pivot;

	if (last > first)
	{
	    pivot = values.get((first + last) / 2);
	    while (f <= l)
	    {
		while (f < last && compare.compare(values.get(f), pivot) < 0)
		    ++f;
		while (l > first && compare.compare(values.get(l), pivot) > 0)
		    --l;
		if (f <= l) {
		    Object temp = values.get(f); 
		    values.set(f, values.get(l));
		    values.set(l, temp);
		    ++f;
		    --l;
		}
	    }

	    if (first < l)
		sort(values, first, l, compare);
	    if (f < last)
		sort(values, f, last, compare);
	}
    }
}
