/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.util.regex.*;

/**
 *	A String Pattern based on regular expressions.
 */
public class RegexpPattern extends StringPattern implements CharSequence
{
    Matcher matcher;
    char[] toMatch;

    public RegexpPattern(Pattern pattern) {
	super(null, 0);
	matcher = pattern.matcher(this);
    }

    public boolean matches(char[] string) {
	toMatch = string;
	return matcher.matches();
    }

    public String fixedPrefix() {
	return "";	//TODO
    }

    public char charAt(int index) {
	return toMatch[index];
    }

    public int length() {
	return toMatch.length;
    }

    public CharSequence subSequence(int start, int end) {
	return null; // not used;
    }

    public String toString() {
	return "Regexp " + matcher.pattern().pattern();
    }
 }
