/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *  	Matching of a string with a pattern.
 *  	<p>This superclass implements the identity comparison.
 */
public class StringPattern
{
    char[] pattern;
    boolean exact = true;

    public StringPattern(char[] pattern, int length) {
	setPattern(pattern, length);
    }

    protected void setPattern(char[] pattern, int length) {
	this.pattern = pattern;
	if(pattern != null && pattern.length != length) {
	    this.pattern = new char[length];
            System.arraycopy(pattern, 0, this.pattern, 0, length);
        }
    }

    public boolean exactMatch() {
	return exact;
    }
    /**
     *	Returns the leading constant part of the pattern. Used to boost matching
     *	and lookup in indexes.
     */
    public String fixedPrefix() {
	return new String(pattern);
    }

    public String toString() {
	return "Word "+new String(pattern);
    }

    public char[] getPattern() {
        return pattern;
    }
    /**
     *	Redefinable matching method.
     */
    public boolean matches(char[] string) {
	if(string.length != pattern.length)
	    return false;
	for(int i = string.length; --i >= 0; )
	    if(string[i] != pattern[i])
		return false;
	return true;
    }
} // end of class StringPattern
