/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.util.time;

/**
 *	Representation of a GDay value.
 */
public class GDay extends DateTimeBase
{
    public GDay( int day, int tzSign, int tzHour, int tzMinute ) throws DateTimeException {
        super( EPOCH, 1, day, 0, 0, 0, tzSign, tzHour, tzMinute );
    }

    public GDay( DateTimeBase dt ) throws DateTimeException  {
        this( dt.day, dt.tzSign, dt.tzHour, dt.tzMinute );
    }

    public DateTimeBase parse( String that, int implicitTimeZone ) throws DateTimeException {
	return parseGDay(that);
    }

    public static GDay parseGDay(String s) throws DateTimeException {
	int day;
	int[] tz = new int[3];

	if (!s.startsWith("---"))
	    throw new DateTimeException("invalid gDay syntax", s);
	int pos = 3;

	int tzPos = parseTimeZone(s, pos, tz);
	if (tzPos != pos+2)
	    throw new DateTimeException("invalid gDay syntax", s);
	day = parseInt(s, pos, tzPos);

	GDay parsed;
	try {
	    parsed = new GDay(day, tz[0], tz[1], tz[2]);
	} catch (IllegalArgumentException e) {
	    throw new DateTimeException("invalid gDay value", s);
	}
	return parsed;
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();
	buffer.append("---");
	appendPadded(day, 2, buffer);
	appendTimeZone(tzSign, tzHour, tzMinute, buffer);
	return buffer.toString();
    }

} // end of class GDay
