/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util.time;

/**
 *	Representation of a GMonth item value.
 */
public class GMonth extends DateTimeBase
{
    public GMonth( int month, int tzSign, int tzHour, int tzMinute ) throws DateTimeException {
        super( EPOCH, month, 1, 0, 0, 0, tzSign, tzHour, tzMinute );
	// add controls here
    }

    public GMonth( DateTimeBase dt ) throws DateTimeException {
        this( dt.month, dt.tzSign, dt.tzHour, dt.tzMinute );
    }

    public DateTimeBase parse( String that, int implicitTimeZone ) throws DateTimeException {
	return parseGMonth(that);
    }

    public static GMonth parseGMonth(String s) throws DateTimeException {
	int month;
	int[] tz = new int[3];

	if (!s.startsWith("--"))
	    throw new DateTimeException("invalid gMonth syntax", s);

	int pos = 2;
	int tzPos = parseTimeZone(s, pos, tz);
	if (tzPos != pos+2)
	    throw new DateTimeException("invalid gMonth syntax", s);
	month = parseInt(s, pos, tzPos);

	return new GMonth(month, tz[0], tz[1], tz[2]);
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();
	buffer.append("--");
	appendPadded( month, 2, buffer );
	appendTimeZone( tzSign, tzHour, tzMinute, buffer );
	return buffer.toString();
    }

} // end of class GMonth

