/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery;

import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.fn.UserFunction;
import net.xfra.qizxopen.util.QName;

import java.io.*;
import java.util.Vector;

/**
 *	Expression dump utility.	
 */
public class ExprDump
{
    PrintWriter out = new PrintWriter(System.out, true);
    int  depth = -1;
    int  level = 2;	// most verbose
    boolean indent = true;

    public ExprDump( ) {
    }

    public ExprDump( int level ) {
	this.level = level;
    }

    public void setOutput(PrintWriter value) {
        out = value;
    }
    public boolean pretty() {
	return level == 0;
    }

    public void header( Expression e, String name ) {
	print(name);
	if(level >= 2) {
	    print(" at "+e.location + ", type "+e.getType());	//+" "+e.module);
	    int flags = e.getFlags();
	    if(flags != 0) {
		print(" flags: ");
		if((flags & Expression.DOCUMENT_ORDER) != 0) print("O "); 
		if((flags & Expression.WITHIN_NODE) != 0) print("W "); 
		if((flags & Expression.SAME_DEPTH) != 0) print("D "); 
		if((flags & Expression.UNORDERED) != 0) print("U "); 
		if((flags & Expression.CONSTANT) != 0) print("C "); 
	    }
	}
	println("");
    }

    public void displayp( String field, Expression e ) {
	++ depth;
	if(level >= 1) {
	    print(field); out.print(" = "); 
	}
	else {
	    print(field); out.print(' ');
	} 
	if(e == null)
	    println("<null>");
	else e.dump(this);
	-- depth;
    }

    public void display( String field, Expression e ) {
	++ depth;
	if(level >= 1) {
	    print(field); out.print(" = "); 
	}
	if(e == null)
	    println("<null>");
	else e.dump(this);
	-- depth;
    }

    public void display( String field, Type e ) {
	++ depth;
	if(level >= 1) {
	    print(field); out.print(" = "); 
	}
	if(e == null)
	    println("<null>");
	else e.dump(this);
	-- depth;
    }

    public void display( String field, Vector e ) {
	++ depth;
	if(level >= 1) {
	    print(field); println(" ="); 
	}
	for(int i = 0; i < e.size(); i++) {
	    Object f = e.get(i);
	    if(f instanceof Expression) {
		if(level >= 1) print("* ");
		((Expression) f).dump(this);
	    }
	    else if(f instanceof Type) {
		if(level >= 1) print("* ");
		((Type) f).dump(this);
	    }
	    else if(f instanceof UserFunction) {
		if(level >= 1) print("* ");
		((UserFunction) f).dump(this);
	    }
	    else if(f != null)
		println(f.toString());
	    else println("<void>");
	}
	-- depth;
    }

    public void display( String field, Expression e[] ) {
	++ depth;
	if(level >= 1) {
	    print(field); println(" ="); 
	}
	if(e != null)
	    for(int i = 0; i < e.length; i++) {
		if(level >= 1) print("* ");
		e[i].dump(this);
	    }
	-- depth;
    }

    public void display( String field, QName qname) {
	++ depth;
	if(level >= 1) {
	    print(field); out.print(" = "); 
	}
	if(qname == null)
	    println("<null>");
	else {
	    println(qname.toString());
	}
	-- depth;
    }

    public void display( String field, String value ) {
	++ depth; 
	if(level >= 1) {
	    print(field); out.print(" = ");
	}
	println(value); // println("|"); 
	-- depth;
    }

    public void display( String field, int value ) {
	++ depth; 
	if(level >= 1) {
	    print(field); out.print(" = ");
	}
	println(""+value);
	-- depth;
    }

    public void depth( int delta ) {
	depth += delta;
    }

    public void print( String s ) {
	if(indent)
	    for(int i =0; i < depth; i++) out.print("   ");
	indent = false;
	out.print(s);
    }

    public void println( String s ) {
	print(s);
	out.println();
	indent = true;
    }

} // end of class ExprDump

