/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery;

/**
 *	Provides access to context item, position and size.
 *	Passed to every eval method, and typically implemented by 
 *	expressions that modify the focus, namely Path and Filter.
 *	(internal use).
 */
public interface Focus
{
    /**
     *	Gets the current item.
     */
    Item getItem();

    /**
     *	Gets the current item as an integer for optimization.
     *	TODO: same for double string etc.
     */
    long getItemAsInteger() throws XQueryException;

    /**
     *	Gets current item position.
     *	Note: 'int' prevent sequences of more than 2 billion items. Real problem ?
     */
    int  getPosition();

    /**
     *	Gets context size.
     */
    int  getLast() throws XQueryException;
}
