/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery;

import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.dt.SingleItem;

/**
 *  class ItemType: encompasses AtomicType (anyAtomicType) and NodeType.
 */
public class ItemType extends Type {

    protected ItemType parent;
    
    /**
    *	The '*' type sequence associated with this atomic type.
    */
    public SequenceType star;
    /**
    *	The '+' type sequence associated with this atomic type.
    */
    public SequenceType plus;
    /**
    *	The empty or length 1 SequenceType associated with this atomic type.
    */
    public SequenceType opt;
    
    public ItemType() {
        star = new SequenceType(this, OPTMULTI_OCC);
        plus = new SequenceType(this, MULTI_OCC);
        opt = new SequenceType(this, OPT_OCC);
    }
    
    public boolean accepts( Type valueType ) {
        // a SequenceType must be reduced, because the occ can be checked only at run-time
        valueType = valueType.getItemType();
        // the trick
        return getClass().isAssignableFrom(valueType.getClass());
    }
    
    public boolean acceptsItem( Item item ) {
        return accepts(item.getType());
    }
    
    public ItemType getItemType() {
        return this;
    }
    
    public String getShortName() {
        return "anySimpleType";
    }
    
    public ItemType getSuperType() {
        return parent;
    }

    /**
     *	SuperType with slight differences wrt XSD: introduces NumericType, MomentType
     */
    public boolean isSuperType(ItemType subtype ) {
	return getClass().isAssignableFrom(subtype.getClass());
    }
    
    /**
     *	Derived in the sense of XSD hierarchy.
     */
    public boolean isDerivedFrom( ItemType root ) {
	for(ItemType ty = this; ty != null; ty = ty.getSuperType())
	    if(ty.getClass() == root.getClass())
		return true;   
	return false;
    }
     
    /**
     *	Attempts to cast the current item of the value to this type.
     *  @return if successful, the converted value as a single item sequence.
     *  @throws xquery.TypeException if the item's type or value is incompatible.
     */
    public Value cast( Value value, EvalContext context ) throws TypeException {
	return new SingleItem( value.asItem() );
    }

    /**
     *	Conversion of external Java array of related type to internal value.
     */
    public Value  convertFromArray( Object object ) {
	throw new RuntimeException("ItemType.convertFromArray");
     }

    /**
     *	Conversion of internal value to external Java array of proper type.
     *	For example: xs:short produces short[].
     */
    public Object convertToArray( Value value ) throws XQueryException {
	throw new RuntimeException("ItemType.convertToArray");
    }
}
