/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.LimitReachedException;
import net.xfra.qizxopen.dm.*;

/**
 *	An implementation of XMLEventReceiver that builds a CoreDataModel tree.
 *	<p>Used in XQ node constructors.
 */
public class EventDrivenBuilder extends XMLEventReceiverBase
{
    CoreDataModel.SNode  root;
    CoreDataModel.Element current;
    CoreDataModel.SNode  previous;
    int  orderStamp = 1;

    /**
     *	extends XMLEventReceiverBase only for traverse. Doesnt use its prefix map.
     */

    public  Node crop() {
	return root;
    }

    public String resolvePrefix( String prefix ) {
	return (current == null) ? null : current.getNsUri(prefix);
    }

    public void reset() {
	previous = root = current = null;
    }

    public void terminate() {
    }

    public void startDocument() throws DataModelException {
	if(root != null)
	    throw new DataModelException("document inside document");
	root = current = CoreDataModel.newDocumentNode();
	previous = null;	// should be already
    }

    public void endDocument() throws DataModelException {
	closeNode();
    }

    public void startElement(QName name) throws DataModelException {
	if(maxVolume > 0 && volume > maxVolume)
	    throw new LimitReachedException(VOLUME_LIMIT);
	CoreDataModel.Element e = CoreDataModel.newElement(name);
	openNode(e);
    }

    public void endElement(QName name) throws DataModelException {
	if(maxVolume > 0 && volume > maxVolume)
	    throw new LimitReachedException(VOLUME_LIMIT);
	closeNode();
    }

    public void namespace(String prefix, String uri) throws DataModelException {
	if(current == null)
	    throw new DataModelException("stray namespace");
	CoreDataModel.Attribute ns = CoreDataModel.newNSNode(prefix);
	ns.value = uri;
	addAttribute(ns);	// yes
	volume += uri.length();
    }

    public void attribute(QName name, String value) throws DataModelException {
	if(maxVolume > 0 && volume > maxVolume)
	    throw new LimitReachedException(VOLUME_LIMIT);
	if(current == null)
	    throw new DataModelException("stray attribute");
	CoreDataModel.Attribute attr = CoreDataModel.newAttribute(name);
	attr.value = value;
	addAttribute(attr);
	volume += value.length();
    }

    public void text(String value) throws DataModelException {
	if(maxVolume > 0 && volume > maxVolume)
	    throw new LimitReachedException(VOLUME_LIMIT);
	if(previous != null && previous.getNature() == Node.TEXT) {
	    previous.addText(value);
	}
	else {
	    addNode( new CoreDataModel.TextNode(value) );
	}
	spaceNeeded = false;
	volume += value.length();
    }

    public void atom(String value) throws DataModelException {
	if(maxVolume > 0 && volume > maxVolume)
	    throw new LimitReachedException(VOLUME_LIMIT);
	if(previous != null && previous.getNature() == Node.TEXT) {
	    if(spaceNeeded)
		previous.addText(" ");
	    previous.addText(value);
	}
	else {
	    addNode( new CoreDataModel.TextNode(value) );
	}
	spaceNeeded = true;
	volume += value.length();
    }

    public void pi(String target, String value) throws DataModelException {
	if(maxVolume > 0 && volume > maxVolume)
	    throw new LimitReachedException(VOLUME_LIMIT);
	CoreDataModel.PINode pi = new CoreDataModel.PINode(target, value);
	addNode(pi);
	volume += value.length();
    }

    public void comment(String value) throws DataModelException {
	if(maxVolume > 0 && volume > maxVolume)
	    throw new LimitReachedException(VOLUME_LIMIT);
	CoreDataModel.CommentNode c = new CoreDataModel.CommentNode(value);
	addNode(c);
	volume += value.length();
    }

    // adds a node as child of the current element.
    private void addNode( CoreDataModel.SNode n ) throws DataModelException {
	n.parent = current;
	if(previous != null)
	    previous.setNextSibling(n);
	else {
	    if(current == null)
		if(root != null)
		    throw new DataModelException("adding node after root");
		else root = current = (CoreDataModel.Element) n;
	    else
		current.firstChild = n;
	}
	previous = n;
	// improves order comparisons tremendously : 
	n.order = orderStamp ++;
    }

    private void openNode( CoreDataModel.Element e ) throws DataModelException {
	addNode(e);
	current = e;
	previous = null;	
	volume += 10;	// arbitrary
    }

    private void closeNode() throws DataModelException {
	if(current == null)
	    if(maxVolume > 0 && volume > maxVolume)
		return;
	    else throw new DataModelException("no open element");
	previous = current;
	current = current.parent;
	volume += 10;	// arbitrary
    }

    private void addAttribute(CoreDataModel.Attribute a) throws DataModelException {
	if(current.getFirstChild() != null)
	    throw new DataModelException("attribute added after contents");
	current.addAttribute(a);
	a.order = orderStamp ++;
	volume += 10;	// arbitrary
    }

    public void  flushElement( boolean empty ) {    }	// dummy

} 
