/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.op.Expression;

public interface LibraryLink
{
    // return Library as wrapped object (empty sequence if not found)
    Value openLibrary( String uri, EvalContext context )
	throws XQueryException;

    // creates and returns a Library as wrapped object
    Value createLibrary( String uri ) throws XQueryException;

    // 
    Value destroyLibrary( String uri ) throws XQueryException;

    /*
     *	Finds a collection by absolute path. 
     *	@param uri path of the collection, including path of the Library.
     *	@param context evaluation context, can also be used for security check.
     *  @return the collection as a sequence of (root) nodes, or null if not found.
     *	@throws XQueryException on system error, or denial of permission (security).
     */
    Value findCollection( String uri )
	throws XQueryException;

    /*
     *	Finds a document by absolute path. 
     *	@param uri path of the document, including path of the Library.
     *	@param context evaluation context, can also be used for security check.
     *  @return the root node of the document, or null if not found.
     *	@throws XQueryException on system error, or denial of permission (security).
     */
    Value findDocument( String uri )
	throws XQueryException;

    /*
     *	Compiles and evaluates a meta-query.
     */
    Value metaQuery( Object library, Expression query, EvalContext context )
	throws XQueryException;

    /*
     *	Finds a query plan for a path expression and evaluates.
     */
    Value evalPath( Expression path, Focus focus, EvalContext context )
	throws XQueryException;

    String PROP = ":liblink";
    String TRACEQUERY = ":trace_query";
}
