/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;

public class AnyURIType extends AtomicType {

    public String getShortName() {
        return "anyURI";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	String result = null;
	try {
	    result = value.asString();
	} catch (TypeException e) {
	    throw new TypeException("cannot cast to xs:anyURI: "+ e.getMessage());
        }
	return new SingleString( result, Type.ANYURI);	//TODO control value
    }
}
