/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.dm.Node;
import java.math.BigDecimal;
import java.text.Collator;

/**
 *	Default Value implementation.
 *	<p>The <code>as<i>Type</i>()</code> methods implemented by this class always
 *	throw errors.
 *	Subclasses must redefine these methods according to the values held.
 */
public abstract class BaseValue implements Value
{
    // CAUTION: asItem() should not return 'this' : else possible infinite loop

    protected ItemType itemType;

    public boolean  nextCollection() throws XQueryException {
	return next();
    }

    public ItemType  getType() {
	return itemType;
    }

    public Item    asAtom() throws TypeException {
	return asItem();
    }

    public boolean asBoolean() throws TypeException {
	throw new TypeException(getClass().getName()+" not castable to boolean");
    }

    public long   asInteger() throws TypeException {
	throw new TypeException(getClass().getName()+" not castable to integer");
    }

    public BigDecimal  asDecimal() throws TypeException {
	throw new TypeException(getClass().getName()+" not castable to decimal");
    }

    public float   asFloat() throws TypeException {
	throw new TypeException(getClass().getName()+" not castable to float");
    }

    public double  asDouble() throws TypeException {
	throw new TypeException(getClass().getName()+" not castable to double");
    }

    public String  asString()  throws TypeException {
	throw new TypeException(getClass().getName()+" not castable to string");
    }

    public Node    asNode() throws TypeException {
	TypeException e = new TypeException(getClass().getName()+" not castable to node");
	
	throw e;
    }

    public boolean  isNode() {
	return false;
    }

    public int compareTo( Item that, Collator collator, int implicitTimeZone )
	throws TypeException {
	return UntypedAtomicType.comparison( this, that, collator);
    }

    public boolean deepEqual( Item item, Collator collator ) {
	return equals(item);
    }

    public boolean worthExpanding() {
	return true;	// default behaviour
    }

    public void setLazy(boolean value) { }	// ignored

    // default: can be optimized by some iterators
    public long quickCount(EvalContext context) throws XQueryException {
	try {
	    setLazy(true);
	    long cnt = 0;
	    for( ; this.next(); ) {
		if((cnt & 31) == 0)
		    context.at(null);
		++ cnt;
	    }
	    return cnt;
	}
	catch (EmptyException e) {
	    return 0;
	}
    }
} // end of class BaseValue

