/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

public class BooleanType extends AtomicType {

    public String getShortName() {
        return "boolean";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	boolean result = false;
	try {
	    if(type == Type.BOOLEAN || Type.NUMERIC.accepts(type))
		return new SingleBoolean( value.asBoolean() );
	    String s = value.asString();
	    if(s.equals("true") || s.equals("1"))
		return new SingleBoolean(true);
	    if(s.equals("false") || s.equals("0"))
		return new SingleBoolean(false);
	    throw new TypeException("cannot cast to xs:boolean: "+s);
	} catch (TypeException e) {
	    throw new TypeException("cannot cast to xs:boolean: "+ e.getMessage());
        }
    }

    public Value  convertFromObject( Object object ) {
	return new SingleBoolean( ((Boolean) object).booleanValue() );
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return Boolean.valueOf(expr.evalAsBoolean(focus, context));
    }
}
