/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	
 */
public abstract class BooleanValue extends BaseValue
{
    public BooleanValue() {
	itemType = Type.BOOLEAN;
    }

    public Item  asItem() throws TypeException {
	return new SingleBoolean( asBoolean() );
    }

    public double  asDouble() throws TypeException {
	return Conversion.toDouble( asBoolean() ); 
    }

    public long  asInteger() throws TypeException {
	return Conversion.toInteger( asBoolean() ); 
    }

    public String  asString()  throws TypeException {
        return Conversion.toString( asBoolean() ); 
    }

    public int compareTo( Item that, Collator c, int implicitTimeZone ) throws TypeException {
	if( !Type.BOOLEAN.accepts( that.getType() ) )
	    return INCOMPARABLE;
	boolean b = that.asBoolean();
	return (asBoolean() == b) ? 0 : b ? -1 : 1;
    }

} // end of class BooleanValue

