/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

public class ByteType extends ShortType {

    public String getShortName() {
        return "byte";
    }

    protected long upperBound() {
	return Byte.MAX_VALUE;
    }
    protected long lowerBound() {
	return Byte.MIN_VALUE;
    }

    public Value  convertFromObject( Object object ) {
	return new SingleInteger( ((Byte) object).byteValue(), Type.BYTE );
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return new Byte( (byte) expr.evalAsInteger(focus, context));
    }

    public Value  convertFromArray( Object object ) {
	byte[] result = (byte[]) object;
	return new IntegerArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return IntegerArraySequence.expandBytes( value );
    }
}
