/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Namespace;

public class CharType extends UnsignedIntType {

    public QName getName() {
	return QName.get(Namespace.XDT, getShortName());
    }

    public String toString() {
	return "xdt:char";
    }

    public String getShortName() {
        return "char";
    }

    public boolean accepts( Type that ) {
	return Type.INTEGER.accepts(that);
    }

    public Value  convertFromObject( Object object ) {
	return new SingleInteger( ((Character) object).charValue(), Type.CHAR );
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return new Character( (char) expr.evalAsInteger(focus, context));
    }

    public Value  convertFromArray( Object object ) {
	char[] result = (char[]) object;
	return new IntegerArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return IntegerArraySequence.expandChars( value );
    }
}
