/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;

public class DateType extends MomentType {

    public String getShortName() {
        return "date";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	Date result = null;
	try {
	    if(type instanceof StringType || type instanceof NodeType)
		result = Date.parseDate( value.asString(),
					 context.getImplicitTimezone() );
	    else if(type == Type.DATE || type == Type.DATE_TIME)
		result = new Date(((MomentValue) value.asItem()).getValue());
	    else throw new DateTimeException("invalid type "+type);
	} catch (DateTimeException e) {
	    throw new TypeException("cannot cast to xs:date : "+ e.getMessage());
        }
	return new SingleMoment( result, Type.DATE );
    }
}
