/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import java.util.HashSet;

/**
 *	Removes duplicate items from a source value.
 */
public class DistinctValueSequence extends GenericValue
{
    public DistinctValueSequence( Value source ) {
        this.source = source;
    }

    public boolean next() throws XQueryException {
	for(; source.next(); ) {
	    item = source.asAtom();	// BUGFIX: atomization required
	    if( !seenSet.contains(item) ) {
		seenSet.add(item);
		return true;
	    }
/* BUG:
	    item = source.asItem();
	    // Caution: equals and HashCode on Node are based on identity, not on string-value.
	    Object value = item.isNode() ? item.asNode().getStringValue() : (Object) item;
	    if( !seenSet.contains(value) ) {
		seenSet.add(value);
		return true;
	    }
*/
	}
	return false;
    }

    public Value  bornAgain() {
	return new DistinctValueSequence( source.bornAgain() );
    }

    Value source;
    HashSet seenSet = new HashSet();
} // end of class DistinctValueSequence
