/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

public class DoubleType extends NumericType {

    public String getShortName() {
        return "double";
    }

    public boolean accepts( Type that ) {
	return Type.NUMERIC.accepts(that);	// not super.accepts() !
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
        try {
	    return new SingleDouble( value.asDouble() );
        }
        catch (TypeException e) {
	    throw new TypeException("cannot cast to xs:double: "+ e.getMessage());
        }
    }

    public Value  convertFromObject( Object object ) {
	return new SingleDouble( ((Double) object).doubleValue() );
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return new Double(expr.evalAsDouble(focus, context));
    }

    public Value  convertFromArray( Object object ) {
	double[] result = (double[]) object;
	return new FloatArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return FloatArraySequence.expandDoubles( value );
    }
}
