/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	Abstract double value.
 */
public abstract class DoubleValue extends BaseValue
{
    public DoubleValue() {
	itemType = Type.DOUBLE;
    }

    public Item  asItem() throws TypeException {
	return new SingleDouble( asDouble() );
    }

    public boolean  asBoolean() throws TypeException {
	double d = asDouble();
	return d == d && d != 0;	// d==d tests NaN
    }

    public long    asInteger() throws TypeException {
	return (long) Math.round( asDouble() );
    }

    public String  asString( )  throws TypeException {
        return Conversion.toString( asDouble() ); 
    }

    public boolean equals( Object that ) {
	if(! (that instanceof Item) )
	    return false;
        try {
	    Item thatItem = (Item) that;
	    return thatItem.getType() == Type.DOUBLE && asDouble() == thatItem.asDouble();
        }
        catch (TypeException e) { return false; }
    }

    public int hashCode() {
	try {
	    long bits = Double.doubleToLongBits(asDouble());
	    return (int) (bits ^ (bits >>> 32));
        }
        catch (Exception e) { return 0; }	// cannot happen
    }

    public int compareTo( Item that, Collator c, int implicitTimeZone)
	throws TypeException {
	if( !Type.DOUBLE.accepts( that.getType() ) )
	    return INCOMPARABLE;
	return Util.comparison( asDouble() - that.asDouble() );
    }
}

