/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.GYear;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.xquery.*;

public class GYearType extends MomentType {

    public String getShortName() {
        return "gYear";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	GYear result = null;
	try {
	    if(type instanceof StringType)
		result = GYear.parseGYear( value.asString() );
	    else if(Type.INTEGER.accepts(type) )
		result = new GYear( (int) value.asInteger(), 0, 0, 0 );
	    else if(type == Type.DATE || type == Type.DATE_TIME)
		result = new GYear(((MomentValue) value.asItem()).getValue());
	    else throw new DateTimeException("invalid type "+type);
	} catch (DateTimeException e) {
	    throw new TypeException("cannot cast to xs:gYear : "+ e.getMessage());
        }
	return new SingleMoment( result, Type.G_YEAR );
    }
}
