/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;

import java.util.Enumeration;
import java.util.Vector;
import java.util.ArrayList;
import java.lang.reflect.Array;

/**
 *	A sequence that stores Object items in an array.
 */
public class ObjectArraySequence extends GenericValue
{
    protected Object[] items;
    protected int size;
    protected int index = -1;

    public ObjectArraySequence(Object[] items, int size, ItemType itemType) {
        this.items = items;
	this.size = size;
	this.itemType = itemType;
    }

    public ObjectArraySequence( Vector vector, ItemType itemType ) {
	items = vector.toArray();
	size = items.length;
	this.itemType = itemType;
    }

    public ObjectArraySequence( ArrayList vector, ItemType itemType ) {
	items = vector.toArray();
	size = items.length;
	this.itemType = itemType;
    }

    public ObjectArraySequence( Enumeration enu, ItemType itemType ) {
	Object[] items = new Object[4];
	int ptr = 0;
	for(; enu.hasMoreElements(); ) {
	    if(ptr >= items.length) {
		Object[] old = items;
		items = new Object[ old.length * 2 ];
		System.arraycopy(old, 0, items, 0, old.length);
	    }
	    items[ptr ++] = enu.nextElement();
        }
	this.items = items;
	this.size = ptr;
	this.itemType = itemType;
    }

    public boolean next() throws XQueryException {
	if(++ index >= size)
	    return false;
	if(items[index] instanceof String)
	    item = new SingleString( (String) items[index]);
	else	// TODO OPTIM
	    item = new SingleWrappedObject(items[index], itemType);
	return true;
    }

    public Value  bornAgain() {
	return new ObjectArraySequence( items, size, itemType );
    }

    private static Object[] newArray(Class itemClass, int size) {
	return itemClass == null?
	       new Object[size]
	    : (Object[]) Array.newInstance(itemClass, size);
    }

    /**
     *	Converts a Value representing a sequence of objects into an array.
     */
    public static Object[] expand(Value value, Class itemClass)
	throws XQueryException {
	Object[] items = newArray(itemClass, 8);
	int ptr = 0;
	for(; value.next(); ) {
	    if(ptr >= items.length) {
		Object[] old = items;
		items = newArray(itemClass, old.length * 2);
		System.arraycopy(old, 0, items, 0, old.length);
	    }
	    ItemType typ = value.getType();
	    Object item = null;
	    if(typ == Type.STRING)
		item = value.asString();
	    else if(typ instanceof WrappedObjectType)
		item = ((WrappedObjectValue) value.asItem()).getObject();
	    else item = value.asItem();
	    try {
		items[ptr ++] = item;
	    }
	    catch (ArrayStoreException e) {	// type checking too loose
		throw new TypeException("bad item type: "+typ+
					", in Java array["+itemClass+"]");
	    }
        }
	// return a full array: TODO OPTIM
	if(ptr == items.length)
	    return items;
	Object[] ritems = newArray(itemClass, ptr);
	System.arraycopy(items, 0, ritems, 0, ptr);
	return ritems;
    }
} 
