/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;

public class QNameType extends AtomicType {

    public String getShortName() {
        return "QName";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	QName result = null;
	String name = value.asString();
	try {
	    result = context.getStaticContext().getInScopeNS().expandName( name );
	}
        catch (IllegalArgumentException e) {
            throw new TypeException("cannot cast to xs:QName : "+e.getMessage());
        }
	if(result == null)
	    throw new TypeException("cannot cast "+ name +" to xs:QName : unknown prefix");
	return new SingleQName( result );
    }
}
