/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;

/**
 *	
 */
public class ReverseArraySequence extends ArraySequence
{
    public ReverseArraySequence( Object[] items, int size ) {
        super(items, size);
	reset();
    }

    public ReverseArraySequence( int initialSize ) {
	super(initialSize);
    }

    public ReverseArraySequence( Value value ) throws XQueryException {
	super(8);
	for(; value.next(); ) 
	    addItem( value.asItem() );
	pack();
	reset();
    }

    public Value  bornAgain() {
	return new ReverseArraySequence( items, size );
    }

    public boolean next() throws XQueryException {
	if(-- index < 0)
	    return false;
	item = (Item) items[index];
	return true;
    }

    public void reset() {
	index = size;
    }
} // end of class ReverseArraySequence
