/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import java.math.BigDecimal;

/**
 *	A scalar Integer value.
 */
public class SingleInteger extends IntegerValue
{
    private long value;
    private boolean started = false;

    public SingleInteger( long value ) {
	this(value, Type.INTEGER);
   
    }

    public SingleInteger( long value, ItemType subType ) {
	this.value = value;
	itemType = subType;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleInteger(value, itemType);
    }

    public long asInteger() {
	return value;
    }

    public BigDecimal  asDecimal() throws TypeException {
	return Conversion.toDecimal(asInteger());
    }

    public String toString() {
	return "SingleInteger "+value+" "+itemType;
    }

} // end of class SingleInt

