/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;

/**
 *	Scalar typed String value. Has by default the type xs:string, but can be used
 *	to represent subtypes of String, like NCName.
 *	
 */
public class SingleString extends StringValue
{
    private String value;
    private boolean started = false;

    public SingleString( String value ) {
	this.value = value;
    }

    public SingleString( String value, ItemType itemType ) {
	this.value = value;
	this.itemType = itemType;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleString(value, itemType);
    }

    public String asString() {
	return value;
    }

    public String toString() {
	return "SingleString('"+value+"', "+getType()+")";
    }

} // end of class SingleString

