/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	Implementation of a single item of type dateTime, date, time, gDay etc.
 */
public class SingleWrappedObject extends WrappedObjectValue
{
    protected Object value;
    private boolean started = false;

    public SingleWrappedObject( Object wrapped ) {
	this.value = wrapped;
    }

    public SingleWrappedObject( Object wrapped, ItemType itemType ) {
	this.value = wrapped;
	this.itemType = itemType;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleWrappedObject(value);
    }

    public Object getObject() {
	return value;
    }
} 

