/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;

/**
 *	A sequence that stores String items in an array.
 */
public class StringArraySequence extends GenericValue
{
    protected String[] items;
    protected int size;
    protected int index = -1;

    public StringArraySequence( String[] items, int size ) {
        this.items = items;
	this.size = size;
    }

    public boolean next() throws XQueryException {
	if(++ index >= size)
	    return false;
	item = new SingleString(items[index]);	// Hmmm
	return true;
    }

    public Value  bornAgain() {
	return new StringArraySequence( items, size );
    }

    /**
     *	Converts a Value representing a sequence of strings into an array.
     */
    public static String[] expand(Value value) throws XQueryException {
	String[] items = new String[8];
	int ptr = 0;
	for(; value.next(); ) {
	    if(ptr >= items.length) {
		String[] old = items;
		items = new String[ old.length * 2 ];
		System.arraycopy(old, 0, items, 0, old.length);
	    }
	    items[ptr ++] = value.asString();
        }
	// return a full array: TODO OPTIM
	String[] ritems = new String[ptr];
	System.arraycopy(items, 0, ritems, 0, ptr);
	return ritems;
    }
} 
