/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	Base class for String sequences.
 */
public abstract class StringValue extends BaseValue
{
    public StringValue() {
	itemType = Type.STRING;
    }

    public Item  asItem() throws TypeException {
	return new SingleString( asString(), itemType );
    }

    public boolean  asBoolean() throws TypeException {
	String d = asString();
	return d.length() != 0;	
    }

    public long   asInteger() throws TypeException {
	return Conversion.toInteger( asString() ); 
    }

    public double asDouble() throws TypeException {
	return Conversion.toDouble( asString() ); 
    }

    public boolean equals( Object that ) {
	if(! (that instanceof Item) )
	    return false;
        try {
	    return asString().equals( ((Item) that).asString() );
        }
        catch (TypeException e) { return false; }
    }

    public int hashCode() {
	try {
	    return asString().hashCode();
        }
        catch (Exception e) { return 0; }	// cannot happen
    }

    public static int   compare(String s1, String s2, Collator coll) {
	int cmp = coll != null ? coll.compare(s1, s2) : s1.compareTo(s2);
	return cmp < 0 ? -1 : cmp > 0 ? 1 : 0;
    }

    public int compareTo( Item that, Collator collator, int implicitTimeZone )
	throws TypeException {
	ItemType thatType = that.getType();
	if(thatType != getType())
	    if(Type.UNTYPED_ATOMIC.accepts(itemType))
		return UntypedAtomicType.comparison( this, that, collator );
	    else if( /*  !Type.UNTYPED_ATOMIC.accepts(thatType) &&     REDUNDANT */
		!Type.STRING.accepts( that.getType() ) )
		return INCOMPARABLE;
	// compare string values:
	return compare( asString(), that.asString(), collator );
    }

} // end of class StringValue

