/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;

public class TimeType extends MomentType {

    public String getShortName() {
        return "time";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	Time result = null;
	try {
	    if(type instanceof StringType || type instanceof NodeType)
		result = Time.parseTime( value.asString(),
					 context.getImplicitTimezone() );
	    else if(type == Type.TIME || type == Type.DATE_TIME)
		result = new Time(((MomentValue) value.asItem()).getValue());
	    else throw new DateTimeException("invalid type "+type);
	} catch (DateTimeException e) {
	    throw new TypeException("cannot cast to xs:time : "+ e.getMessage());
        }
	return new SingleMoment( result, Type.TIME );
    }
}
