/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;


public class UntypedAtomicType extends StringType /*trick*/ {

    public QName getName() {
	return Type.untypedAtomic;
    }

    public String getShortName() {
        return "untypedAtomic";
    }

    public String toString() {
	return "xdt:untypedAtomic";
    }

    // compares an atomic value with another item
    public static int comparison( Item item1, Item item2, Collator collator)
	throws TypeException {
	ItemType type2 = item2.getType();
	if(!Type.UNTYPED_ATOMIC.accepts(type2))	// no loop please
	    // reverse comparison:
	    return - item2.compareTo(item1, collator, 0);
	// both items are UNTYPED_ATOMIC: string compare
	return StringValue.compare( item1.asString(), item2.asString(), collator );
    }
}
