/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:base-uri.
 */
public class BaseUri extends Function {

    static Prototype[] protos = { 
        Prototype.fn("base-uri", Type.STRING.opt, Exec.class) .arg("srcval", Type.NODE),
        Prototype.fn("base-uri", Type.STRING.opt, Exec.class)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
            if(args.length == 0)
		return context.getStaticContext().getBaseURI();
	    else
		return args[0].evalAsNode(focus, context).getBaseURI();
        }
    }
}
