/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;

import net.xfra.qizxopen.xquery.op.Expression;

/**
 *  Generic Implementation of functions xs:*().
 */
public class CastFunction extends Function {

    static Prototype[] protos = { 
        Prototype.xs("cast", Type.ANY, Exec.class) .arg("srcval", Type.ATOM)
    };
    public Prototype[] getProtos() { return protos; }	// dummy

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    Expression expr = args[0];
	    Value arg = expr.eval(focus, context), result = null;
            context.at(this);
	    if( !arg.next() )
		context.error(expr, Type.ERR_EMPTY_UNEXPECTED);
	    try {
		result = prototype.returnType.getItemType().cast(arg, context);
	    }
	    catch (TypeException err) {
		context.error(expr, err);
	    }
	    if( arg.next() )
		context.error(expr, Type.ERR_TOO_MANY);
	    return result;
	}
    }
}
