/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:codepoints-to-string.
 */
public class CodepointsToString extends Function {

    static Prototype[] protos = { 
        Prototype.fn("codepoints-to-string", Type.STRING, Exec.class)
            .arg("srcval", Type.INTEGER.star)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.StringCall {

        public String evalAsString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Value cpts = args[0].eval(focus, context);
	    StringBuffer buf = new StringBuffer();
	    for(; cpts.next(); )
		buf.append((char) cpts.asInteger());
	    return buf.toString();
        }
    }
}
