/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *  Implementation of function fn:compare.
 */
public class Compare extends Function {

    static Prototype[] protos = { 
        Prototype.fn("compare", Type.INTEGER.opt, Exec.class)
            .arg("comparand1", Type.STRING.opt)
            .arg("comparand2", Type.STRING.opt),
        Prototype.fn("compare", Type.INTEGER.opt, Exec.class)
            .arg("comparand1", Type.STRING.opt)
            .arg("comparand2", Type.STRING.opt)
            .arg("collationLiteral", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.IntegerCall {

        public long evalAsInteger(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    String s1 = args[0].evalAsOptString(focus, context);
	    String s2 = args[1].evalAsOptString(focus, context);
	    if(s1 == null || s2 == null)
		throw EmptyException.allowed();
	    Collator coll = args.length < 3 ? 
		null : context.getCollator(args[2].evalAsString(focus, context));
            context.at(this);
	    return Util.comparison( coll != null ?
				    coll.compare(s1, s2) : s1.compareTo(s2) );
        }
    }
}
