/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NodeSortExpr;

/**
 *  Implementation of function fn:count. TODO unordered
 */
public class Count extends Function {

    static Prototype[] protos = { 
        Prototype.fn("count", Type.INTEGER, RT.class).arg("srcval", Type.ITEM.star),
    };

    public Prototype[] getProtos() { return protos; }

    public Expression staticCheck( StaticContext context, Expression[] arguments,
				   Expression subject )	{
	Expression ex = super.staticCheck(context, arguments, subject);
	RT rt = (RT) ex;
	// change the result type to the type of the argument (may be empty -> optional)
	if( rt.args.length > 0 &&	// error protection
	    rt.args[0] instanceof NodeSortExpr) {
	    NodeSortExpr nodso = (NodeSortExpr) rt.args[0];
	    rt.args[0] = nodso.expr;
	}	
        return rt;
    }

    public static class RT extends Function.IntegerCall {

	public long evalAsInteger(Focus focus, EvalContext context)
	    throws XQueryException {
	    try {
		Value v = args[0].eval(focus, context);
		context.at(this);
		return v.quickCount( context );
	    }
	    catch (EmptyException e) {
		return 0;
	    }
	}
    }
}
