/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

//	Extension: a function which guarantees that all its
//	arguments are evaluated in order.
//
public class Do extends Function {

    static Prototype[] protos = { 
        Prototype.varfn("do", Type.ANY, Exec.class) .arg("op", Type.ANY)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {
        public Value eval(Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);
	    StringBuffer buf = new StringBuffer();
	    for(int s = 0; s < args.length; s++) {
		Value v = args[s].eval(focus, context);
		context.at(this);
		for(; v.next(); )
		    ;
	    }
	    return Value.empty;
        }
    }
}
